<?php
defined('is_running') or die('Not an entry point...');


class gp_strings{

	/**
	 * Return an array of character entities and their corresponding iso (numeric) code
	 * @since 2.4b5
	 */
	static function iso_entities(){
		return array( '&#32;'=>'', '&#34;'=>'"', '&#38;'=>'&', '&#60;'=>'<', '&#62;'=>'>', '&#124;'=>'|', '&#131;'=>'ƒ', '&#132;'=>'„', '&#133;'=>'…', '&#134;'=>'†', '&#135;'=>'‡', '&#136;'=>'ˆ', '&#137;'=>'‰', '&#138;'=>'Š', '&#139;'=>'‹', '&#140;'=>'Œ', '&#144;'=>'', '&#145;'=>'‘', '&#146;'=>'’', '&#147;'=>'“', '&#148;'=>'”', '&#149;'=>'•', '&#150;'=>'–', '&#151;'=>'—', '&#152;'=>'˜', '&#153;'=>'™', '&#154;'=>'š', '&#155;'=>'›', '&#156;'=>'œ', '&#159;'=>'Ÿ', '&#160;'=>''
		, '&#161;'=>'¡', '&#162;'=>'¢', '&#163;'=>'£', '&#164;'=>'¤', '&#165;'=>'¥', '&#166;'=>'¦', '&#167;'=>'§', '&#168;'=>'¨', '&#169;'=>'©', '&#170;'=>'ª', '&#171;'=>'«', '&#172;'=>'¬', '&#173;'=>'­', '&#174;'=>'®', '&#175;'=>'¯', '&#176;'=>'°', '&#177;'=>'±', '&#178;'=>'²', '&#179;'=>'³', '&#180;'=>'´', '&#181;'=>'µ', '&#182;'=>'¶', '&#183;'=>'·', '&#184;'=>'¸', '&#185;'=>'¹', '&#186;'=>'º', '&#187;'=>'»', '&#188;'=>'¼', '&#189;'=>'½', '&#190;'=>'¾', '&#191;'=>'¿', '&#192;'=>'À'
		, '&#193;'=>'Á', '&#194;'=>'Â', '&#195;'=>'Ã', '&#196;'=>'Ä', '&#197;'=>'Å', '&#198;'=>'Æ', '&#199;'=>'Ç', '&#200;'=>'È', '&#201;'=>'É', '&#202;'=>'Ê', '&#203;'=>'Ë', '&#204;'=>'Ì', '&#205;'=>'Í', '&#206;'=>'Î', '&#207;'=>'Ï', '&#208;'=>'Ð', '&#209;'=>'Ñ', '&#210;'=>'Ò', '&#211;'=>'Ó', '&#212;'=>'Ô', '&#213;'=>'Õ', '&#214;'=>'Ö', '&#215;'=>'×', '&#216;'=>'Ø', '&#217;'=>'Ù', '&#218;'=>'Ú', '&#219;'=>'Û', '&#220;'=>'Ü', '&#221;'=>'Ý', '&#222;'=>'Þ', '&#223;'=>'ß'
		, '&#224;'=>'à', '&#225;'=>'á', '&#226;'=>'â', '&#227;'=>'ã', '&#228;'=>'ä', '&#229;'=>'å', '&#230;'=>'æ', '&#231;'=>'ç', '&#232;'=>'è', '&#233;'=>'é', '&#234;'=>'ê', '&#235;'=>'ë', '&#236;'=>'ì', '&#237;'=>'í', '&#238;'=>'î', '&#239;'=>'ï', '&#240;'=>'ð', '&#241;'=>'ñ', '&#242;'=>'ò', '&#243;'=>'ó', '&#244;'=>'ô', '&#245;'=>'õ', '&#246;'=>'ö', '&#247;'=>'÷', '&#248;'=>'ø', '&#249;'=>'ù', '&#250;'=>'ú', '&#251;'=>'û', '&#252;'=>'ü', '&#253;'=>'ý', '&#254;'=>'þ'
		, '&#255;'=>'ÿ', '&#338;'=>'Œ', '&#339;'=>'œ', '&#352;'=>'Š', '&#353;'=>'š', '&#376;'=>'Ÿ', '&#402;'=>'ƒ', '&#710;'=>'ˆ', '&#732;'=>'˜', '&#913;'=>'Α', '&#914;'=>'Β', '&#915;'=>'Γ', '&#916;'=>'Δ', '&#917;'=>'Ε', '&#918;'=>'Ζ', '&#919;'=>'Η', '&#920;'=>'Θ', '&#921;'=>'Ι', '&#922;'=>'Κ', '&#923;'=>'Λ', '&#924;'=>'Μ', '&#925;'=>'Ν', '&#926;'=>'Ξ', '&#927;'=>'Ο', '&#928;'=>'Π', '&#929;'=>'Ρ', '&#931;'=>'Σ', '&#932;'=>'Τ', '&#933;'=>'Υ', '&#934;'=>'Φ', '&#935;'=>'Χ'
		, '&#936;'=>'Ψ', '&#937;'=>'Ω', '&#945;'=>'α', '&#946;'=>'β', '&#947;'=>'γ', '&#948;'=>'δ', '&#949;'=>'ε', '&#950;'=>'ζ', '&#951;'=>'η', '&#952;'=>'θ', '&#953;'=>'ι', '&#954;'=>'κ', '&#955;'=>'λ', '&#956;'=>'μ', '&#957;'=>'ν', '&#958;'=>'ξ', '&#959;'=>'ο', '&#960;'=>'π', '&#961;'=>'ρ', '&#962;'=>'ς', '&#963;'=>'σ', '&#964;'=>'τ', '&#965;'=>'υ', '&#966;'=>'φ', '&#967;'=>'χ', '&#968;'=>'ψ', '&#969;'=>'ω', '&#977;'=>'ϑ', '&#978;'=>'ϒ', '&#982;'=>'ϖ', '&#8194;'=>' '
		, '&#8195;'=>' ', '&#8201;'=>' ', '&#8204;'=>'‌', '&#8205;'=>'‍', '&#8206;'=>'‎', '&#8207;'=>'‏', '&#8211;'=>'–', '&#8212;'=>'—', '&#8216;'=>'‘', '&#8217;'=>'’', '&#8218;'=>'‚', '&#8220;'=>'“', '&#8221;'=>'”', '&#8222;'=>'„', '&#8224;'=>'†', '&#8225;'=>'‡', '&#8226;'=>'•', '&#8230;'=>'…', '&#8240;'=>'‰', '&#8242;'=>'′', '&#8243;'=>'″', '&#8249;'=>'‹', '&#8250;'=>'›', '&#8254;'=>'‾', '&#8260;'=>'⁄', '&#8364;'=>'€', '&#8465;'=>'ℑ', '&#8472;'=>'℘'
		, '&#8476;'=>'ℜ', '&#8482;'=>'™', '&#8501;'=>'ℵ', '&#8592;'=>'←', '&#8593;'=>'↑', '&#8594;'=>'→', '&#8595;'=>'↓', '&#8596;'=>'↔', '&#8629;'=>'↵', '&#8656;'=>'⇐', '&#8657;'=>'⇑', '&#8658;'=>'⇒', '&#8659;'=>'⇓', '&#8660;'=>'⇔', '&#8704;'=>'∀', '&#8706;'=>'∂', '&#8707;'=>'∃', '&#8709;'=>'∅', '&#8711;'=>'∇', '&#8712;'=>'∈', '&#8713;'=>'∉', '&#8715;'=>'∋', '&#8719;'=>'∏', '&#8721;'=>'∑', '&#8722;'=>'−', '&#8727;'=>'∗', '&#8730;'=>'√', '&#8733;'=>'∝'
		, '&#8734;'=>'∞', '&#8736;'=>'∠', '&#8743;'=>'∧', '&#8744;'=>'∨', '&#8745;'=>'∩', '&#8746;'=>'∪', '&#8747;'=>'∫', '&#8756;'=>'∴', '&#8764;'=>'∼', '&#8773;'=>'≅', '&#8776;'=>'≈', '&#8800;'=>'≠', '&#8801;'=>'≡', '&#8804;'=>'≤', '&#8805;'=>'≥', '&#8834;'=>'⊂', '&#8835;'=>'⊃', '&#8836;'=>'⊄', '&#8838;'=>'⊆', '&#8839;'=>'⊇', '&#8853;'=>'⊕', '&#8855;'=>'⊗', '&#8869;'=>'⊥', '&#8901;'=>'⋅', '&#8968;'=>'⌈', '&#8969;'=>'⌉', '&#8970;'=>'⌊'
		, '&#8971;'=>'⌋', '&#9001;'=>'⟨', '&#9002;'=>'⟩', '&#9674;'=>'◊', '&#9824;'=>'♠', '&#9827;'=>'♣', '&#9829;'=>'♥', '&#9830;'=>'♦' );
	}

	/**
	 * Return an array of character entities and their corresponding html (non-numeric) code
	 * @since 2.4b5
	 */
	static function html_entities(){
		return array( '&quot;'=>'"', '&amp;'=>'&', '&frasl;'=>'⁄', '&lt;'=>'<', '&gt;'=>'>', '&nbsp;'=>'', '&iexcl;'=>'¡', '&cent;'=>'¢', '&pound;'=>'£', '&curren;'=>'¤', '&yen;'=>'¥', '&brvbar;'=>'¦', '&brkbar;'=>'¦', '&sect;'=>'§', '&uml;'=>'¨', '&die;'=>'¨', '&copy;'=>'©', '&ordf;'=>'ª', '&laquo;'=>'«', '&not;'=>'¬', '&shy;'=>'­', '&reg;'=>'®', '&macr;'=>'¯', '&hibar;'=>'¯', '&deg;'=>'°', '&plusmn;'=>'±', '&sup2;'=>'²', '&sup3;'=>'³', '&acute;'=>'´', '&micro;'=>'µ', '&para;'=>'¶'
		, '&middot;'=>'·', '&cedil;'=>'¸', '&sup1;'=>'¹', '&ordm;'=>'º', '&raquo;'=>'»', '&frac14;'=>'¼', '&frac12;'=>'½', '&frac34;'=>'¾', '&iquest;'=>'¿', '&Agrave;'=>'À', '&Aacute;'=>'Á', '&Acirc;'=>'Â', '&Atilde;'=>'Ã', '&Auml;'=>'Ä', '&Aring;'=>'Å', '&AElig;'=>'Æ', '&Ccedil;'=>'Ç', '&Egrave;'=>'È', '&Eacute;'=>'É', '&Ecirc;'=>'Ê', '&Euml;'=>'Ë', '&Igrave;'=>'Ì', '&Iacute;'=>'Í', '&Icirc;'=>'Î', '&Iuml;'=>'Ï', '&ETH;'=>'Ð', '&Ntilde;'=>'Ñ', '&Ograve;'=>'Ò', '&Oacute;'=>'Ó'
		, '&Ocirc;'=>'Ô', '&Otilde;'=>'Õ', '&Ouml;'=>'Ö', '&times;'=>'×', '&Oslash;'=>'Ø', '&Ugrave;'=>'Ù', '&Uacute;'=>'Ú', '&Ucirc;'=>'Û', '&Uuml;'=>'Ü', '&Yacute;'=>'Ý', '&THORN;'=>'Þ', '&szlig;'=>'ß', '&agrave;'=>'à', '&aacute;'=>'á', '&acirc;'=>'â', '&atilde;'=>'ã', '&auml;'=>'ä', '&aring;'=>'å', '&aelig;'=>'æ', '&ccedil;'=>'ç', '&egrave;'=>'è', '&eacute;'=>'é', '&ecirc;'=>'ê', '&euml;'=>'ë', '&igrave;'=>'ì', '&iacute;'=>'í', '&icirc;'=>'î', '&iuml;'=>'ï', '&eth;'=>'ð'
		, '&ntilde;'=>'ñ', '&ograve;'=>'ò', '&oacute;'=>'ó', '&ocirc;'=>'ô', '&otilde;'=>'õ', '&ouml;'=>'ö', '&divide;'=>'÷', '&oslash;'=>'ø', '&ugrave;'=>'ù', '&uacute;'=>'ú', '&ucirc;'=>'û', '&uuml;'=>'ü', '&yacute;'=>'ý', '&thorn;'=>'þ', '&yuml;'=>'ÿ', '&OElig;'=>'Œ', '&oelig;'=>'œ', '&Scaron;'=>'Š', '&scaron;'=>'š', '&Yuml;'=>'Ÿ', '&fnof;'=>'ƒ', '&circ;'=>'ˆ', '&tilde;'=>'˜', '&Alpha;'=>'Α', '&Beta;'=>'Β', '&Gamma;'=>'Γ', '&Delta;'=>'Δ', '&Epsilon;'=>'Ε', '&Zeta;'=>'Ζ'
		, '&Eta;'=>'Η', '&Theta;'=>'Θ', '&Iota;'=>'Ι', '&Kappa;'=>'Κ', '&Lambda;'=>'Λ', '&Mu;'=>'Μ', '&Nu;'=>'Ν', '&Xi;'=>'Ξ', '&Omicron;'=>'Ο', '&Pi;'=>'Π', '&Rho;'=>'Ρ', '&Sigma;'=>'Σ', '&Tau;'=>'Τ', '&Upsilon;'=>'Υ', '&Phi;'=>'Φ', '&Chi;'=>'Χ', '&Psi;'=>'Ψ', '&Omega;'=>'Ω', '&alpha;'=>'α', '&beta;'=>'β', '&gamma;'=>'γ', '&delta;'=>'δ', '&epsilon;'=>'ε', '&zeta;'=>'ζ', '&eta;'=>'η', '&theta;'=>'θ', '&iota;'=>'ι', '&kappa;'=>'κ', '&lambda;'=>'λ', '&mu;'=>'μ', '&nu;'=>'ν'
		, '&xi;'=>'ξ', '&omicron;'=>'ο', '&pi;'=>'π', '&rho;'=>'ρ', '&sigmaf;'=>'ς', '&sigma;'=>'σ', '&tau;'=>'τ', '&upsilon;'=>'υ', '&phi;'=>'φ', '&chi;'=>'χ', '&psi;'=>'ψ', '&omega;'=>'ω', '&thetasym;'=>'ϑ', '&upsih;'=>'ϒ', '&piv;'=>'ϖ', '&ensp;'=>' ', '&emsp;'=>' ', '&thinsp;'=>' ', '&zwnj;'=>'‌', '&zwj;'=>'‍', '&lrm;'=>'‎', '&rlm;'=>'‏', '&ndash;'=>'–', '&mdash;'=>'—', '&lsquo;'=>'‘', '&rsquo;'=>'’', '&sbquo;'=>'‚', '&ldquo;'=>'“', '&rdquo;'=>'”'
		, '&bdquo;'=>'„', '&dagger;'=>'†', '&Dagger;'=>'‡', '&bull;'=>'•', '&hellip;'=>'…', '&permil;'=>'‰', '&prime;'=>'′', '&Prime;'=>'″', '&lsaquo;'=>'‹', '&rsaquo;'=>'›', '&oline;'=>'‾', '&euro;'=>'€', '&image;'=>'ℑ', '&weierp;'=>'℘', '&real;'=>'ℜ', '&trade;'=>'™', '&alefsym;'=>'ℵ', '&crarr;'=>'↵', '&lArr;'=>'⇐', '&uArr;'=>'⇑', '&rArr;'=>'⇒', '&dArr;'=>'⇓', '&hArr;'=>'⇔', '&forall;'=>'∀', '&part;'=>'∂', '&exist;'=>'∃', '&empty;'=>'∅', '&nabla;'=>'∇'
		, '&isin;'=>'∈', '&notin;'=>'∉', '&ni;'=>'∋', '&prod;'=>'∏', '&sum;'=>'∑', '&minus;'=>'−', '&lowast;'=>'∗', '&radic;'=>'√', '&prop;'=>'∝', '&infin;'=>'∞', '&ang;'=>'∠', '&and;'=>'∧', '&or;'=>'∨', '&cap;'=>'∩', '&cup;'=>'∪', '&int;'=>'∫', '&there4;'=>'∴', '&sim;'=>'∼', '&cong;'=>'≅', '&asymp;'=>'≈', '&ne;'=>'≠', '&equiv;'=>'≡', '&le;'=>'≤', '&ge;'=>'≥', '&sub;'=>'⊂', '&sup;'=>'⊃', '&nsub;'=>'⊄', '&sube;'=>'⊆', '&supe;'=>'⊇', '&oplus;'=>'⊕'
		, '&otimes;'=>'⊗', '&perp;'=>'⊥', '&sdot;'=>'⋅', '&lceil;'=>'⌈', '&rceil;'=>'⌉', '&lfloor;'=>'⌊', '&rfloor;'=>'⌋', '&lang;'=>'⟨', '&rang;'=>'⟩', '&larr;'=>'←', '&uarr;'=>'↑', '&rarr;'=>'→', '&darr;'=>'↓', '&harr;'=>'↔', '&loz;'=>'◊', '&spades;'=>'♠', '&clubs;'=>'♣', '&hearts;'=>'♥', '&diams;'=>'♦', );
	}

	/**
	 * Return an array of character entities and all of their corresponding html codes
	 * @since 2.4b5
	 */
	static function all_entities(){
		return gp_strings::iso_entities() + gp_strings::html_entities();
	}

	/**
	 * Convert all entities to their character equivalent
	 * @since 2.5b1
	 */
	static function entity_unescape($string){
		//change &#0039; to &#39;
		$string = preg_replace('/&#[0]+([1-9]+);/','&#$1;',$string);

		$all_entities = gp_strings::all_entities();
		return str_replace(array_keys($all_entities),array_values($all_entities),$string);
	}

	/**
	 * Convert characters to their entity equivalent
	 * @since 2.5b1
	 */
	static function entity_escape($string){
		$all_entities = gp_strings::all_entities();
		return str_replace(array_keys($all_entities),array_values($all_entities),$string);
	}

}
